from collections import namedtuple

# datová struktura pro záznam údajů o státě
Stát = namedtuple('stát', 'plocha obyvatel hustota')

# načtení dat
lidi = {}
with open('staty_lidi.log') as f:
    for line in f:
        stát, lidí = line.strip().split(': ')
        lidi[stát] = lidí

plochy = {}
with open('staty_plochy.log') as f:
    for line in f:
        stát, plocha = line.strip().split(': ')
        plochy[stát] = plocha

# hustoty
hustoty = {}
for stát, plocha in plochy.items():
    lidí = lidi.get(stát, 0)
    hustoty[stát] = Stát(plocha, lidí, int(lidí) / float(plocha))
print(len(hustoty))     # 261
#print(hustoty)

for stát, data in sorted(hustoty.items(), key=lambda x: x[1].hustota):
    print(f'{stát}: {data[0]} & {data[1]} => {data[2]}')
